/*---------------------------------------------------------------------------
 PROJET     : Couche de portabilite multi-systeme
 
 PLATE-FORME: WIN32
 
 MODULE     : Definition des macros et des types utilises par la couche 
              d'abstraction systeme pour la plate-forme WIN32.
              
              Le fichier de definition des types portable (ce fichier) doit 
              etre inclus avant tout autre .h de definitions d'APIS gip-cps. 
              Ce fichier definit tous les types et macros dependants du 
              systeme. 

 FICHIER    : common\win32\src\win32def.h

 VERSION    : 1.00
 
 DATE       : 10/09/96
 
 AUTEUR     : A. TIGE
 
-----------------------------------------------------------------------------
-----------------------------------------------------------------------------
 Modifications:  (nouvelle version, date, auteur, explication)
 ...
 24/12/96 : A. TIGE. 
     Modification de API_ENTRY pour passer les points d'entre de DLL au format
     __stdcall, ce qui permet la compatibilite avec les programmes basic 32 bits
     (Bug dans VB 4.0)
 16/12/99 : C. CONVERT. 
	Remplacement du #define d'inclusion win32def.h __CPSCASDF_H par __WIN32DF_H
	Ajout des #define NULL, TRUE, FALSE
 01/02/99 : A. ROCHA
	Ajout du #define LITTLE_ENDIAN approprie aux processeurs x86,
	utilise par l'algorithme PKCS.
  10/03/2000 : A. ROCHA
	Ajout de typedef CHAR  BOOL concerant les fonctions de Cal_rsa2.c
	(@@MOD20000310)
  23/03/2000 : D. RENAULD
	Modification de typedef CHAR  BOOL en typedef int BOOLEEN pour
    conflit avec windef.h!
	(@@MOD20000323)
-----------------------------------------------------------------------------
---------------------------------------------------------------------------*/


#ifndef __WIN32DF_H
#define __WIN32DF_H

/*----------------- definition des macros portables ------------------------*/

/* point d'entree exporte en DLL */
#define API_ENTRY __stdcall   /* pour compatibilit avec le basic */

#define PTR *
#define FARPTR PTR

/* CLCO 16/12/1999 Ajout des #define NULL, TRUE, FALSE */
#ifndef NULL
#define NULL 0
#endif

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif


/* CLCO 16/12/1999 Fin */

/*----------------- definition des types portables ------------------------*/

typedef char CHAR;
typedef CHAR PTR PCHAR;

/* DREN 23/03/2000: Declaration de BOOL en conformite avec WINDEF.H */
/* typedef CHAR BOOL; */
typedef int                 BOOLEEN;
/* DREN 23/03/2000: Fin */

/*typedef CHAR PTR PSTR;      ptr sur chaine ASCIIZ defini dans windows.h */

typedef CHAR PTR PSTRG; 

typedef unsigned char UCHAR;
typedef UCHAR PTR PUCHAR;

#if (_MSC_VER <=1200)

typedef char INT8;
#endif
#ifndef _BASETSD_H_
typedef char INT8, *PINT8;
#endif
typedef short INT16;
//typedef char INT8, *PINT8;
#ifndef _BASETSD_H_
typedef long INT32;
#endif

#if (_MSC_VER <=1200)
//#ifndef __cplusplus
typedef INT8 PTR PINT8;
//#endif
#endif
typedef INT16 PTR PINT16;
typedef INT32 PTR PINT32;

typedef unsigned char UINT8;
typedef unsigned short UINT16;
#ifndef _BASETSD_H_
typedef unsigned long UINT32;
#endif

typedef UINT8 PTR PUINT8;
typedef UINT16 PTR PUINT16;
#ifndef _BASETSD_H_
typedef UINT32 PTR PUINT32;
#endif

typedef double DOUBLE;

#define Unref( a) a=a

/*------------ Definition pour le type de cryptage relatif au processeur ---------*/

#define LITTLE_ENDIAN 


#endif
